
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1108.C - Message 1108 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1108 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1108.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:48   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.6   Jul 09 1997 10:40:52   COLEJ
//    
//   
//      Rev 1.5   Feb 25 1997 14:36:06   COLEJ
//   added validity check in message
//   
//      Rev 1.4   Feb 12 1997 16:05:24   COLEJ
//    
//   
//      Rev 1.3   Sep 05 1996 11:49:16   COLEJ
//    
//   
//      Rev 1.2   Sep 03 1996 12:46:26   COLEJ
//    
//   
//      Rev 1.1   Aug 15 1996 08:49:14   COLEJ
//    
//   
//      Rev 1.0   Aug 14 1996 18:19:08   COLEJ
//   New output message 1108 (Time Mark Output) processing.
//   
//
//
////////////////////////////////////////////////////////////////////////////////
 
#include <stdio.h>
#include <conio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "labmon.h"
#include "display.h"

extern tBOOL              MSG1108ON;      // this flag is used to signal that 1108 messages are being received

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1108 message from the ZMsgBuf.
//
void Show1108(tMSG1108 *Msg)
{
   char                 Buf[80] = "";
   char                 UTCHourMinSec[20]; 
   double               t;
   unsigned short       UTCDays,UTCHours,UTCMinutes,UTCSeconds;
   tBOOL                UTCSynch;       // GPS/UTC Synchronization flag
   tBOOL                TimeMarkValid;  // Time Mark Validity bit flag
   
   extern short         MainTextColor;  
   extern short         MainDataColor;  
   extern void          clear_message_line ( void );

   //make time conversions
   t = (Msg->UTCSeconds * 1.0); // Seconds into week
   UTCDays = (unsigned short)(t / 86400.0);
   t -= (UTCDays * 86400.0);
   UTCHours = (unsigned short)(t / 3600.0);       
   t -= (UTCHours * 3600.0);
   UTCMinutes = (unsigned short)(t / 60.0);
   t -= (UTCMinutes * 60.0);
   UTCSeconds = (unsigned short)(t);

   // make roundoff error corrections
   if( UTCSeconds >= 60 ){ UTCMinutes++; UTCSeconds -= 60; }
   if( UTCMinutes >= 60 ){ UTCHours++;   UTCMinutes -= 60; }
   if( UTCHours   >= 24 ){ UTCDays++;    UTCHours   -= 24; }
            
   //check Time Mark Validity bit
   TimeMarkValid = Msg->UTCTimeValidity & 0x01;   // mask off bit 0 of validity word 
   
   if( !TimeMarkValid ){ MSG1108ON = FALSE; return; }  // if time not valid clear flag and return
   else
      if( !MSG1108ON ){ MSG1108ON = TRUE; return; }    // if first time in set flag and leave( handle querry )
      
   //check UTC Synch bit
   UTCSynch = Msg->UTCTimeValidity & 0x02;   // mask off bit 1 of validity word 


   if( UTCSynch ){
      
      sprintf(UTCHourMinSec,"* %02d:%02d:%02d", UTCHours, UTCMinutes, UTCSeconds);
   }   
   else{
      sprintf(UTCHourMinSec,"  %02d:%02d:%02d", UTCHours, UTCMinutes, UTCSeconds);
   }
   
   // output the data items   
   sprintf(Buf,"%05d"  ,Msg->SequenceNumber          );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%s"    ,UTCHourMinSec                );ShowText(Buf,TIMR+ 1,TIMC+ 7);
}                                                 
                                      
                                           
